module MapReduce where

-- Cada Variable de tipo que usemos en las sgtes firmas
-- viene excplicado en esta secci'on de comentarios.
-- k = llave
-- v = valor
-- i = valor intermedio, producido por la funci'on m
-- u = valor de reduci'on de valores intermedios, producido por la funci'on r

mapReduce :: (Eq v) => (v -> [i] -> u)
                    -> (k -> [v] -> [(v,i)])
                    -> [(k, [v])] -> [(v, u)]
-- La funci'on mapReduce, compuesta por tres etapas: "mapear", agrupar y reducir
mapReduce r m = (reduce_ r) . g . (map_ m)

map_ :: (k -> [v] -> [(v,i)]) -> [(k, [v])] -> [(v,i)]
-- Recibe la funci'on m (del usuario) para aplicar el map value cada (key, values)
map_ m = foldl (\ls (key,values)-> ls ++ (m key values)) [] 

g :: (Eq v) => [(v, i)] -> [(v, [i])]
-- Agrupa todas las llaves intermedias, funci'on usada por mapReduce
-- inter,interr, representan cada uno valores intermedios
g [] = []  
g ((value,inter):rest) =  (:) (value,(groupby value rest))
                              (g (filter (\(other,interr) -> (value /= other)) rest))
 where 	groupby value [] = [inter]
	groupby value ((other,interr):rest) = if (value == other) 
	 then (interr:groupby value rest) else (groupby value rest)
	 
	 
reduce_ :: (v -> [i] -> u) -> [(v, [i])] -> [(v, u)]
-- Recibe la funci'on r (del usuario) para aplicar el reduce a cada grupo
reduce_ r = map (\(value,inters) -> (value,(r value inters)))	 

-- Test1, sobre el ejemplo del enunciado con
-- r = (\_ ys -> sum ys) 
-- m = (\_ xs -> map (\x -> (x,1)) xs)
test1 = mapReduce (\_ ys -> sum ys) (\_ xs -> map (\x -> (x,1)) xs) 
	 	  [("doc1",["a","b","c"]),("doc2",["c","a","a"])]

--inverted_index :: [(k, [v])] -> [(v, [k])]
-- Funci'on que retorna el 'indice invertido de la lista (key, values)
-- esta parametrizada por funciones r y m aplicadas al mapReduce
inverted_index = mapReduce (\_ docs -> foldl (\ls doc -> (if (elem doc ls) then ls else (doc:ls))) 
                                             [] docs) 
                           (\doc keys -> map (\key -> (key,doc)) keys) 

-- Test2, que prueba el ejemplo de 'indice invertido del enunciado, usando el
-- mismo r y m del Test1
test2 = inverted_index [("doc1",['a','b','c']),("doc2",['c','a','a'])]
